/****** Object:  StoredProcedure [dbo].[P_RC_DEB_HISTORICO_RC_CREDIARIO_PARC]    Script Date: 03/26/2014 10:46:14 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_DEB_HISTORICO_RC_CREDIARIO_PARC]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_RC_DEB_HISTORICO_RC_CREDIARIO_PARC]
GO
/****** Object:  StoredProcedure [dbo].[P_RC_DEB_HISTORICO_RC_CREDIARIO_PARC]    Script Date: 17/02/2016 16:55:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- exec P_RC_DEB_HISTORICO_RC_CREDIARIO_PARC 1,'2015-07-15'
CREATE PROCEDURE [dbo].[P_RC_DEB_HISTORICO_RC_CREDIARIO_PARC] @CD_EMP INT=1, @DT_PROC DATETIME=NULL WITH ENCRYPTION AS 
SET NOCOUNT ON
DECLARE @CD_CTR INT
DECLARE @DT_ATUAL DATETIME 
SET @DT_ATUAL=GETDATE()

IF @DT_PROC IS NULL 
begin
	SET @DT_PROC = CONVERT(CHAR(10),GETDATE(),112)
end

CREATE TABLE #RsCredVenda (CD_CTR INT, VLR_PARCELA_SLD MONEY)
CREATE TABLE #RsCredVendaFechamento (CD_CTR INT, VLR_PARCELA_FECHA MONEY)
CREATE TABLE #RsCredVendaRecebimento (CD_CTR INT, VLR_PARCELA_RECEBIMENTO MONEY)
CREATE TABLE #RsCredVendaRecebimentoNCC (CD_CTR INT, VLR_PARCELA_RECEBIMENTO_NCC MONEY)

--Dados de parcela do crediario
INSERT INTO #RsCredVenda
select
	DISTINCT RC_CREDIARIO_PARC.CD_CTR,
	RC_CREDIARIO_PARC.VLR_PARC_CRED
from
	RC_CREDIARIO_PARC INNER JOIN RC_CREDIARIO_PARC_PDV_VD ON
	RC_CREDIARIO_PARC.CD_CTR = RC_CREDIARIO_PARC_PDV_VD.CD_CTR 
WHERE
	RC_CREDIARIO_PARC.CD_EMP =@CD_EMP
	AND RC_CREDIARIO_PARC.DT_LANC_CRED<=@DT_PROC
	AND NOT RC_CREDIARIO_PARC.STS_LANC_CRED IN (2,3,4)

--Dados de fechamento crediario
insert into #RsCredVendaFechamento
SELECT
	RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA.CD_CTR,
	RC_CREDIARIO_PARC.SLD_PARC_CRED
FROM
	RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA INNER JOIN RC_CREDIARIO_FECHA ON
	RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA.CD_CTR_FECHA = RC_CREDIARIO_FECHA.CD_CTR_FECHA
	INNER JOIN RC_CREDIARIO_PARC ON
	RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA.CD_CTR = RC_CREDIARIO_PARC.CD_CTR
	INNER JOIN RC_CREDIARIO_PARC_PDV_VD ON
	RC_CREDIARIO_PARC.CD_CTR = RC_CREDIARIO_PARC_PDV_VD.CD_CTR 
WHERE
	RC_CREDIARIO_PARC.CD_EMP =@CD_EMP
	AND RC_CREDIARIO_FECHA.DT_CAD<=@DT_PROC

--Dados de recebimento por antecipacao
INSERT INTO #RsCredVendaRecebimento
select
	RC_CREDIARIO_PARC_CRED.CD_CTR,
	RC_CREDIARIO_PARC_CRED.VLR_CRED
from
	RC_CREDIARIO_PARC_CRED INNER JOIN RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED ON
	RC_CREDIARIO_PARC_CRED.CD_CTR = RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR 
	INNER JOIN DBO.RC_PGTO_PDV ON 
	RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO 
	INNER JOIN PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON
	RC_PGTO_PDV.CD_CTR_PGTO = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO 
	INNER JOIN DBO.PDV_CUPOM_NAO_FISCAL ON 
	PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP AND 
	PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL AND 
	PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR = PDV_CUPOM_NAO_FISCAL.CD_CTR 
where
	PDV_CUPOM_NAO_FISCAL.DT_CUPOM <=@DT_PROC

--Dados de baixa por NCC
INSERT INTO #RsCredVendaRecebimentoNCC 
SELECT
	RC_CREDIARIO_PARC_CRED.CD_CTR,
	RC_CREDIARIO_PARC_CRED.VLR_CRED
from
	RC_CREDIARIO_PARC_CRED INNER JOIN RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED ON
	RC_CREDIARIO_PARC_CRED.CD_CTR = RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR 
	INNER JOIN RC_CREDIARIO_PARC_PDV_VD_DEV_NCC ON
	RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR = RC_CREDIARIO_PARC_PDV_VD_DEV_NCC.CD_CTR 
	INNER JOIN DBO.RC_PGTO_PDV ON 
	RC_CREDIARIO_PARC_PDV_VD_DEV_NCC.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO
where
	CONVERT(date,DT_PGTO) <=@DT_PROC


SET @CD_CTR=ISNULL((SELECT 
	MAX(CD_CTR)
FROM
	RC_DEB_HISTORICO
WHERE
	DT_PROC=@DT_PROC),0)

IF @CD_CTR > 0
begin
	DELETE 
		FROM RC_DEB_HISTORICO_CPL_RC_CREDIARIO_PARC
	WHERE
		CD_CTR=@CD_CTR

	PRINT 'Lote atual.: ' + CONVERT(VARCHAR, @CD_CTR) + ' Parcelas crediario em aberto ' + convert(varchar,getdate(),108)
end

IF @CD_CTR=0
begin
	INSERT INTO RC_DEB_HISTORICO (DT_PROC,DT_CAD)
	SELECT
		@DT_PROC,
		@DT_ATUAL

	SET @CD_CTR = IDENT_CURRENT( 'RC_DEB_HISTORICO' )
	PRINT 'Lote novo.: ' + CONVERT(VARCHAR, @CD_CTR) + ' Parcelas crediario em aberto ' + convert(varchar,getdate(),108)
end

--Alterando o saldo de parcelas recebimento parcial
UPDATE
	V
SET 
	V.VLR_PARCELA_SLD = (V.VLR_PARCELA_SLD - ISNULL(R.VLR_PARCELA_RECEBIMENTO,0))	
FROM
	#RsCredVenda V INNER JOIN #RsCredVendaRecebimento R on
	v.cd_ctr = R.cd_Ctr 

--Alterando o saldo de parcelas baixa NCC
UPDATE
	V
SET 
	V.VLR_PARCELA_SLD = (V.VLR_PARCELA_SLD - ISNULL(R.VLR_PARCELA_RECEBIMENTO_NCC,0))	
FROM
	#RsCredVenda V INNER JOIN #RsCredVendaRecebimentoNCC R on
	v.cd_ctr = R.cd_Ctr 

--Deletando parcelas com recebimento 
DELETE
	V
FROM
	#RsCredVenda V INNER JOIN #RsCredVendaRecebimento R on
	v.cd_ctr = R.cd_Ctr 
WHERE
	V.VLR_PARCELA_SLD<=0

--Deletando parcelas com fechamento
DELETE
	V
FROM
	#RsCredVenda V INNER JOIN #RsCredVendaFechamento f on
	v.cd_ctr = f.cd_Ctr 
WHERE
	(V.VLR_PARCELA_SLD - ISNULL(F.VLR_PARCELA_FECHA,0))<=0


INSERT INTO RC_DEB_HISTORICO_CPL_RC_CREDIARIO_PARC (
	CD_CTR,
	CD_CTR_PARC,
	VLR_PARC_CRED_SLD)
select
	@CD_CTR,
	V.CD_CTR,
	V.VLR_PARCELA_SLD
from
	#RsCredVenda V

DROP TABLE #RsCredVenda;
DROP TABLE #RsCredVendaFechamento;
DROP TABLE #RsCredVendaRecebimento;
